function Za = approxZcal(x,x00,relmin,p,s)
% Calulates Zcal by parameters x, X00 and p at s
% X00 are abosoulte parmeters 
% X are relative pamrametes
% p are known parametres
% relmin is minimum of x

  l=length(x);
  xmin = ones(1,l)*relmin;
  x=max(x,xmin);
  xx=x00.*x;
  
  Rs =p(1); 
  
  Cs  = xx(1);
  Ci = xx(2);
  Ri = xx(3);
  Cdc = xx(4);
 
  Zs = 1/Rs+ Cs*s; 
  Zs = 1./Zs;  
  Zp = 1./(Ri+1./(s*Cdc))+ Ci*s; 
  Zp = 1./Zp;  
  Za = Zp./Zs * Rs;

end
